﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Test_Tanita_Mosic
{
    class Program
    {
        static void Main(string[] args)
        {
            Dokument doc = new Dokument();
            Paragraf p1 = new Paragraf("Molimo pametne i poštene da čuvaju zdravlje "+
                "i ne gube nadu. Za svaki slučaj. Ako nam niko drugi ne pomogne.");
            doc.addElement(p1);
            Recenica r1= new Recenica("Deco, možete misliti kakav je život kada je od kolevke pa do groba najlepše đačko doba");
            doc.addElement(r1);
            Recenica r2 = new Recenica("Više je znanja i veštine (inteligencije, duha, mašte i ukusa) uložila Koka-kola za "+
                "propagandu svoje obojene i zašećerene vode, nego škola za slavu i veličanje čitanja i pisanja");
            doc.addElement(r2);
            Pravougaonik pr1 = new Pravougaonik(1, 1, 2, 2, "crvena");
            //Pravougaonik p = new Pravougaonik(1, 1, 3, 3, "plava");
            doc.addElement(pr1);
            //doc.addElement(p);
            Console.WriteLine(doc.ToString());
            doc.printText();
            int numofa = doc.letterCount('a') ;
            numofa += doc.letterCount('A');
            Console.WriteLine("U dokuentu se slovo a pojavljuje {0} puta.", numofa);

            Console.ReadKey();
        }

        class ElementUDokumentu
        {
            string Vrsta;
            public string vrsta { set { Vrsta = value; } get { return Vrsta;} }
            public ElementUDokumentu(string vrsta) { this.vrsta = vrsta; }
            public override string ToString()
            { return "Vrsta: " + vrsta +"\n" ; }
            
        }

        abstract class TekstualniElement : ElementUDokumentu
        {
            public abstract string getText();
            public TekstualniElement(string vrsta) : base(vrsta) { this.vrsta = vrsta; }
            public abstract int countLetters(char c);
        }

        class Recenica : TekstualniElement
        {
            string RRecenica;
            public string recenica { set { RRecenica = value; } get { return RRecenica; } }
            public Recenica(string recenica) : base("recenica") { this.recenica = recenica; }
            public override string getText() { return recenica + ".\n"; }
            public override string ToString()
            { return "Vrsta: "+vrsta+"\nSadrzaj: "+this.getText(); }

            public override int countLetters(char c)
            {
                int n = 0;
                n = recenica.Count(x => x == c);
                return n;
            }
        }

        class Paragraf:TekstualniElement
        {
            StringBuilder Tekst=new StringBuilder();
            public StringBuilder tekst { set { Tekst = value; } get { return Tekst; } }
            public Paragraf(string text) : base("paragraf")
            {
                int index = text.IndexOf("\n");
                if(index!=-1)
                text = text.Remove(index);
                tekst.Insert(0, text);
            }
            public Paragraf(Recenica recenica) : base("paragraf") { tekst.Insert(0, recenica.recenica); }
            public void dodajTekst(string text) { tekst.Append(text); }
            public void dodajTekst(Recenica text) { tekst.Append(text); }
            public override string getText() { return tekst + "\n"; }
            public override string ToString()
            { return "Vrsta: " + vrsta + "\nSadrzaj: " + this.getText(); }
            public override int countLetters(char c)
            {
                int n = 0;
                string teksts = tekst.ToString();
                n = teksts.Count(x => x == c);
                return n;
            }
        }

        class GrafickiElement:ElementUDokumentu
        {
            string Boja;
            public string boja { set { Boja = value; } get { return Boja; } }
            public GrafickiElement(string boja, string vrsta) : base(vrsta) { this.boja = boja; }
        }

        class Pravougaonik:GrafickiElement
        {
            int X1,Y1,X2, Y2;
            public int x1 { set { X1 = value; } get { return X1; } }
            public int y1 { set { Y1 = value; } get { return Y1; } }
            public int x2 { set { X2 = value; } get { return X2; } }
            public int y2 { set { Y2 = value; } get { return Y2; } }
            public Pravougaonik(int x1,int y1, int x2, int y2, string boja):base(boja,"pravougaonik")
            { this.x1 = x1; this.x2 = x2; this.y1 = y1; this.y2 = y2; }
            public override string ToString()
            {
                return "Vrsta: "+vrsta+"\n"+boja + "(" + x1 + ", " + y1 + ")" + "\nSirina: " + 
                    Math.Abs(x1 - x2) + "\nVisina: " + Math.Abs(y1 - y2)+"\n";
            }

        }

        class Dokument
        {
            List<GrafickiElement> graficki = new List<GrafickiElement>();
            List<TekstualniElement> tekstualni = new List<TekstualniElement>();
            public void addElement(TekstualniElement textel) { tekstualni.Add(textel); }
            public void addElement(GrafickiElement grafel) { graficki.Add(grafel); }
            public void printText()
            {
                Console.WriteLine("printText");
                foreach (TekstualniElement x in tekstualni)
                {
                    Console.WriteLine(x.ToString());
                }
            }
            public override string ToString()
            {
                Console.WriteLine("ToString");
                StringBuilder s = new StringBuilder();
                foreach (TekstualniElement x in tekstualni)
                {
                    s.Append(x.ToString());
                    s.Append("\n");
                }
                foreach (GrafickiElement x in graficki)
                {
                    s.Append(x.ToString());
                    s.Append("\n");
                }
                string ss = s.ToString();
                return ss;
            }

            public int letterCount(char c)
            {
                int n = 0;
                foreach(TekstualniElement x in tekstualni)
                {
                    n+=x.countLetters(c);
                }
                return n;
            }

        }

    }
}
